IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_SCA_RegistrarAcceso_Rta') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_SCA_RegistrarAcceso_Rta
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_RegistrarAcceso_Rta]
                        @pFlag_Habilitado	TINYINT,
						@pMensaje_Mostrar	VARCHAR(5000),
						@pInfo				VARCHAR(101),
						@pFoto				VARCHAR(256),
						@pFoto_Bin			VARBINARY(MAX),
						@pId_Cliente		INT,
						@pId_Cliente_Ref	INT,
						@pTipoAcceso		CHAR(1),
						@pTag				VARCHAR(MAX),	/*07/10/2021 Agrandado*/
						@pFecha				DATETIME,
						@pId_Controlador	SMALLINT,
						@pId_Acceso			SMALLINT,
						@pId_CD_Motivo		INT,			/*06/06/2019 Agregado*/
						@pFlag_GrabaRegistro TINYINT =	NULL, /*23/09/2019. 1(default): Graba Registro. 0: No graba el registro*/
						@pFlag_Permite_Paso	TINYINT = NULL	/*05/02/2020. 1: Si el resultado es habilitado permite que la persona pase 1 vez mas la proxima vez*/
AS

DECLARE @Resultado								CHAR(1)
DECLARE @Tiempo_Mensaje							SMALLINT
DECLARE @Mensaje								VARCHAR(5000)
DECLARE @Descripcion_Motivo						VARCHAR(5000)
DECLARE @Descripcion_Motivo_Personalizada		VARCHAR(5000)
DECLARE @Descripcion_Motivo_Acceso				VARCHAR(5000)
DECLARE @Descripcion_Display					VARCHAR(32)
DECLARE @Descripcion_Pantalla					VARCHAR(100)

IF(@pFlag_GrabaRegistro IS NULL)
BEGIN
	SET @pFlag_GrabaRegistro = 1
END

IF(@pFlag_Permite_Paso IS NULL)
BEGIN
	SET @pFlag_Permite_Paso = 0
END

CREATE TABLE #rTabla	(Flag_Habilitado	TINYINT,
						Mensaje				VARCHAR(5000),
						Info				VARCHAR(101),
						Foto				VARCHAR(256),
						Foto_Bin			IMAGE,
						Id_Cliente			INT,
						Id_Cliente_Ref		INT,
						Tiempo_Mensaje		SMALLINT)

IF(@pFlag_Habilitado = 1)
BEGIN
	SET @Resultado = 'S'
END
ELSE
BEGIN
	SET @Resultado = 'E'
END

SET @Tiempo_Mensaje = (SELECT ISNULL(Tiempo_Mensaje, 1) FROM CD_Accesos WHERE Id_Acceso = @pId_Acceso)

SELECT
@Descripcion_Motivo					= ISNULL(M.Descripcion, ''),
@Descripcion_Motivo_Personalizada	= ISNULL(M.Descripcion_Personalizada,''),
@Descripcion_Motivo_Acceso			= ISNULL(A.Descripcion_Motivo,''),
@Descripcion_Display				= ISNULL(M.Descripcion_Display, ''),
@Descripcion_Pantalla				= ISNULL(M.Descripcion_Pantalla, '')
FROM CD_Motivos M
	LEFT JOIN CD_Accesos_Motivos A ON M.Id_CD_Motivo = A.Id_Motivo AND A.Id_Acceso = @pId_Acceso
WHERE M.Id_CD_Motivo = @pId_CD_Motivo

IF(@Descripcion_Pantalla <> '')
BEGIN
	SET @Mensaje = @Descripcion_Pantalla
END
ELSE
BEGIN
	IF(@Descripcion_Display <> '')
	BEGIN
		SET @Mensaje = @Descripcion_Display
	END
	ELSE
	BEGIN
		IF(@Descripcion_Motivo_Acceso <> '')
		BEGIN
			SET @Mensaje = @Descripcion_Motivo_Acceso
		END
		ELSE IF(@Descripcion_Motivo_Personalizada <> '')
		BEGIN
			SET @Mensaje = @Descripcion_Motivo_Personalizada
		END
		ELSE
		BEGIN
			SET @Mensaje = @Descripcion_Motivo
		END
	END
END

IF(ISNULL(@pMensaje_Mostrar, '') <> '')
BEGIN
	SET @Mensaje = @Mensaje + ' ' + @pMensaje_Mostrar
END

/*Graba en CD_ES*/
IF(@pFlag_GrabaRegistro = 1)
BEGIN
	INSERT INTO CD_ES
	(Tipo,			Origen,			Id_Tarjeta,
	Id_Cliente,		Fecha,			Resultado,
	Id_Controlador, Id_Acceso,		Observacion,
	tipo_reg,		Id_CD_Motivo,	Flag_Permite_Paso)
	VALUES
	(@pTipoAcceso,		'A',			@pTag,
	@pId_Cliente,		@pFecha,		@Resultado,
	@pId_Controlador,	@pId_Acceso,	@Mensaje,
	'',					@pId_CD_Motivo, @pFlag_Permite_Paso)
END

/*Mensaje a devolver*/
INSERT INTO #rTabla 
(Flag_Habilitado,	Mensaje,	Info, 
Foto,				Foto_Bin,	Id_Cliente, 
Id_Cliente_Ref,		Tiempo_Mensaje) 
VALUES 
(@pFlag_Habilitado,	@Mensaje,	@pInfo, 
@pFoto,				@pFoto_Bin,	@pId_Cliente, 
@pId_Cliente_Ref,	@Tiempo_Mensaje)
	
SELECT * FROM #rTabla

DROP TABLE #rTabla
RETURN
